function [A,b,u,tab]=df(h)

CB1=-4;
CB2=8;

%Calculando cantidad de puntos

na=1.5/h;
nb=2.5/h;
nc=0.5/h;
nd=2/h;
ne=3/h;

%Contruyendo tabla de conversion  i,j <-> k

%nmero de incognitas
N=(nb+1)*(nc+1)+(nd-nc-1)*(na+1)+(nb+1)*(ne-nd+1);
%tabla de conversin
tab=zeros(N,2);
k=1;

%A
for j=1:nc+1
    for i=1:nb+1
        tab(k,1)=i;
        tab(k,2)=j;
        k=k+1;
    end
end

%B
for j=nc+2:nd
    for i=1:na+1
        tab(k,1)=i;
        tab(k,2)=j;
        k=k+1;
    end
end

%C
for j=nd+1:ne+1
    for i=1:nb+1
        tab(k,1)=i;
        tab(k,2)=j;
        k=k+1;
    end
end

%Construyendo la matriz A y el vector b

A=sparse(N,N);
b=sparse(N,1);

%Guardamos ecuacin por ecuacin
for k=1:N
    [i,j]=getIJ(k,tab);
    
    A(k,k)=-4;
    
    if i-1==0 && j-1==0           %a
        A(k,getK(i+1,j,tab))=2;
        A(k,getK(i,j+1,tab))=2;
    elseif i-1==0 && j+1==ne+2    %h
        A(k,getK(i+1,j,tab))=2;
        A(k,getK(i,j-1,tab))=2;
    elseif i-1==0                %1
        A(k,getK(i+1,j,tab))=2;
        A(k,getK(i,j+1,tab))=1;
        A(k,getK(i,j-1,tab))=1;
    elseif j-1==0 && i+1==nb+2    %b
        A(k,getK(i-1,j,tab))=2;
        A(k,getK(i,j+1,tab))=2;
        b(k,1)=-2*CB2*h;
    elseif j-1==0                %2
        A(k,getK(i,j+1,tab))=2;
        A(k,getK(i+1,j,tab))=1;
        A(k,getK(i-1,j,tab))=1;
    elseif i+1==nb+2 && j+1==nc+2 %c
        A(k,getK(i-1,j,tab))=2;
        A(k,getK(i,j-1,tab))=2;
        b(k,1)=-2*CB2*h;
    elseif i+1==nb+2 && j<nc+1   %3
        A(k,getK(i-1,j,tab))=2;
        A(k,getK(i,j+1,tab))=1;
        A(k,getK(i,j-1,tab))=1;
        b(k,1)=-2*CB2*h;
    elseif j+1==nc+2 && i>na+1   %4
        A(k,getK(i,j-1,tab))=2;
        A(k,getK(i-1,j,tab))=1;
        A(k,getK(i+1,j,tab))=1;
    elseif i+1==na+2 && j>nc+1 && j<nd+1    %5
        A(k,getK(i-1,j,tab))=2;
        A(k,getK(i,j+1,tab))=1;
        A(k,getK(i,j-1,tab))=1;
    elseif j-1==nd && i+1==nb+2   %f
        A(k,getK(i-1,j,tab))=2;
        A(k,getK(i,j+1,tab))=2;
        b(k,1)=-2*CB1*h;
    elseif j-1==nd && i>na+1      %6
        A(k,getK(i,j+1,tab))=2;
        A(k,getK(i-1,j,tab))=1;
        A(k,getK(i+1,j,tab))=1;
    elseif i+1==nb+2 && j+1==ne+2   %g
        A(k,getK(i-1,j,tab))=2;
        A(k,getK(i,j-1,tab))=2;
        b(k,1)=-2*CB1*h;
    elseif i+1==nb+2                %7
        A(k,getK(i-1,j,tab))=2;
        A(k,getK(i,j+1,tab))=1;
        A(k,getK(i,j-1,tab))=1;
        b(k,1)=-2*CB1*h;
    elseif j+1==ne+2                %8
        A(k,getK(i,j-1,tab))=2;
        A(k,getK(i+1,j,tab))=1;
        A(k,getK(i-1,j,tab))=1;
    else                            %punto interior
        A(k,getK(i-1,j,tab))=1;
        A(k,getK(i+1,j,tab))=1;
        A(k,getK(i,j+1,tab))=1;
        A(k,getK(i,j-1,tab))=1;
    end        
end

% Se resuelve el sistema

%U=(A^-1)*b;
U=A\b;

% Se ordena la solucin como matriz

u=zeros(nb+1,ne+1)*NaN;

for k=1:N
    [i,j]=getIJ(k,tab);
    u(i,j)=U(k);
end

u=u';
u=u-min(min(u));